<?php 
 /**
  * 
  */
 class Mettre_Carburant extends CI_Controller
 {
  
  function __construct()
  {
    parent::__construct();
    $this->load->library('Mylibrary');
    $this->ci = & get_instance();
    $this->ci->load->library("user_agent");
    $this->Is_Connected();

    }

  public function Is_Connected()
       {

       if (empty($this->session->userdata('SOCAR_ID_USER')))
        {
         redirect(base_url('Login/'));
        }
       }

          public function Is_permis()
       {

       // if ($this->mylibrary->get_permission('Mettre_Carburant') ==0)
       //  {
       //   redirect(base_url('Login/'));
       //  }
       }


  public function index()
  {
      
      $this->Is_permis();
      $title = "Enregistrement ravitaillement du carburant";
      $lastApprovisionnement = $this->Model->getOneOrder('voiture_carburant_consomation',array(),'CONSOMATION_ID');
      $VAL = $lastApprovisionnement['CONSOMATION_ID']+1;
      $NUM_GENERATED = 'CARB-'.$VAL;
      // echo $NUM_GENERATED;
      // exit();
      $approvisionnement = array(
               'CONSOMATION_ID'=>NULL,                                   
               'NUM_GENERATED'=>$NUM_GENERATED,                                   
               'PATH_FACTURE'=>NULL,                                   
               'CONSOMATION_DATE'=>NULL,
               'VEHICULE_ID'=>$this->Model->getList('voiture_vehicules',array()), 
               'STATION_ID'=>$this->Model->getList('voiture_station',array()), 
               'CHAUFFEUR_ID'=>$this->Model->getListOrdered('rh_employe','NOM',array()), 
               'QUANTITE_RECU'=>NULL, 
               // 'TRAJET_ID'=>$this->Model->getList('masque_trajet',array()), 
               'PRIX_CARBURANT_ID'=>$this->Model->getList('voiture_prix_carburant',array()), 
               'MONTANT_CONSOMATION'=>NULL, 
               'PRIX_UNITAIRE'=>NULL, 
               'KM_A_APROVISIONNEMENT'=>NULL, 
              );

        
        $data['title'] = $title;
        // $data['pieces'] = $this->Model->getList("masque_piece");
        $data['approv'] = $approvisionnement;
      $this->load->view("Mettre_Carburant_Add_View",$data);
  }

  public function getlastkm()
  {
    $VEHICULE_ID = $this->input->post('VEHICULE_ID');
    $lastkm = $this->Model->getOneOrder('voiture_carburant_consomation',array('VEHICULE_ID'=>$VEHICULE_ID,'ID_STATUS'=>1,'PANNE_TABLEAU'=>0),'KM_A_APROVISIONNEMENT');

    if ($lastkm['KM_A_APROVISIONNEMENT'] == NULL) {
      echo 0;
    }
    else{
      echo $lastkm['KM_A_APROVISIONNEMENT'];
    }

    
  }

  public function save_mettre_carburant()
  {

        $browser=$this->ci->agent->browser.' version '.$this->ci->agent->version;
        $os=$this->ci->agent->platform;
        $ip = $_SERVER["REMOTE_ADDR"];
        $dt = new DateTime("now", new DateTimeZone('Africa/Bujumbura'));
        $new_dt = $dt->format('Y-m-d H:i:s');

     $approvisionnement = array(          
        'NUM_GENERATED'=>$this->input->post('NUM_GENERATED'),                                 
        'VEHICULE_ID'=>$this->Model->getList('voiture_vehicules',array()), 
        'STATION_ID'=>$this->Model->getList('voiture_station',array()), 
        'QUANTITE_RECU'=>$this->input->post('QUANTITE_RECU'),
        'PROVENANCEOUDESTINATION'=>$this->input->post('PROVENANCEOUDESTINATION'),
        // 'TRAJET_ID'=>$this->Model->getList('masque_trajet',array()), 
        'MONTANT_CONSOMATION'=>$this->input->post('MONTANT_CONSOMATION'),
        'PRIX_UNITAIRE'=>$this->input->post('PRIX_UNITAIRE'),
        'CONSOMATION_DATE'=>$this->input->post('CONSOMATION_DATE'),
        'KM_A_APROVISIONNEMENT'=>$this->input->post('KM_A_APROVISIONNEMENT'),
        'PATH_FACTURE'=>$this->input->post('PATH_FACTURE'),
        'CHAUFFEUR_ID'=>$this->input->post('CHAUFFEUR_ID'),
        );

     if ($this->input->post('PANNE_TABLEAU') == NULL) {
       $PANNE_TABLEAU = 0;
     }
     else{
      $PANNE_TABLEAU = 1;
     }


     
     if ($this->input->post('CONSOMATION_DATE') == NULL) {
      $message = "<div class='alert alert-danger'>
                            un probleme est survenue. Verifier votre dernier enregistrement
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";

      
      $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('voiture/Mettre_Carburant')); 
     }
     else{
    $myDateTime = DateTime::createFromFormat('d/m/Y', $this->input->post('CONSOMATION_DATE'));
     $newdate = $myDateTime->format('Y-m-d');
     }


     $repPhotoo =FCPATH.'/uploads/document_carburant';
    $documents=uniqid();
    $document_carburant = $_FILES['PATH_FACTURE']['name'];
    $config['upload_path'] ='./uploads/document_carburant/';
    $config['allowed_types'] = '*';
    // $test = explode('.', $document_preuve);
    // $ext = end($test);
    // $name = $documents.'_document_preuve.' . $ext;
    $name = $document_carburant;
    $config['file_name'] =$name;
    if(!is_dir($repPhotoo)) //create the folder if it does not already exists   
      {
        mkdir($repPhotoo,0777,TRUE);                                                        
      } 

    $this->upload->initialize($config);
    $this->upload->do_upload('PATH_FACTURE');
    $image_name_main=$config['file_name'];
    $data_image=$this->upload->data();
    if ($image_name_main != NULL) {
      $PATH_FACTURE = $image_name_main;
    }
    else{
      $PATH_FACTURE = NULL;
    }

     $data = array(          
        'NUM_GENERATED'=>$this->input->post('NUM_GENERATED'),                                 
        'VEHICULE_ID'=>$this->input->post('VEHICULE_ID'),                                   
        'STATION_ID'=>$this->input->post('STATION_ID'),
        'QUANTITE_RECU'=>$this->input->post('QUANTITE_RECU'),
        // 'PROVENANCEOUDESTINATION'=>$this->input->post('PROVENANCEOUDESTINATION'),
        // 'TRAJET_ID'=>$this->input->post('TRAJET_ID'),
        'MONTANT_CONSOMATION'=>$this->input->post('MONTANT_CONSOMATION'),
        'PRIX_UNITAIRE'=>$this->input->post('PRIX_UNITAIRE'),
        'USERSAVER'=>$this->session->userdata('SOCAR_ID_USER'),
        'CONSOMATION_DATE'=>$newdate,
        'KM_A_APROVISIONNEMENT'=>$this->input->post('KM_A_APROVISIONNEMENT'),
        'CHAUFFEUR_ID'=>$this->input->post('CHAUFFEUR_ID'),
        'PATH_FACTURE'=>$PATH_FACTURE,
        'PANNE_TABLEAU'=>$PANNE_TABLEAU,
        'BUJUMBURA_TIME'=>$new_dt,
        'NAVIGATEUR'=>$browser,
        'OPERATING_SYSTEM'=>$os,
        'INTERNET_IP'=>$ip,
        );
     // echo "<pre>";
     // print_r($data);
     // exit();
     
     $this->form_validation->set_rules('VEHICULE_ID', 'Vehicule', 'required');
     $this->form_validation->set_rules('STATION_ID', 'Station', 'required');
     $this->form_validation->set_rules('QUANTITE_RECU', 'Nb littre', 'required');
     // $this->form_validation->set_rules('TRAJET_ID', 'Provenance ou Destination', 'required');
     $this->form_validation->set_rules('MONTANT_CONSOMATION', 'Montant consomation', 'required');
     $this->form_validation->set_rules('PRIX_UNITAIRE', 'Prix unitaire', 'required');
     $this->form_validation->set_rules('CONSOMATION_DATE', 'Date facturation', 'required');
     $this->form_validation->set_rules('KM_A_APROVISIONNEMENT', 'Km approvisionnement', 'required');
     $this->form_validation->set_rules('CHAUFFEUR_ID', 'Chauffeur', 'required');

    //SI Valide
     if ($this->form_validation->run() == FALSE){        
        
        $title = "Mettre du carburant";

        $message = "<div class='alert alert-danger' id='message'>
                            Donne manquantes, Processus échoué.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";

        $data['title'] = $title;        
        $data['approv'] = $approvisionnement;
        $this->session->set_flashdata(array('message'=>$message));
       $this->load->view("Mettre_Carburant_Add_View",$data);

      }else{
        $this->Model->insert_last_id('voiture_carburant_consomation',$data);
        
          $message = "<div class='alert alert-success'  id='message'>
                            Enregistrement fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Mettre_Carburant/'));
      }
  }



  public function listing()
    {
      $PERIODE = $this->input->post('PERIODE');
      $VEHICULE_ID = $this->input->post('VEHICULE_ID');
      $data['STATION_IDS']= $this->input->post('STATION_ID');
      $STATION_ID = $this->input->post('STATION_ID');
      if ($STATION_ID != NULL) {
        $data['condstation'] = 'AND car.STATION_ID ='.$STATION_ID.' ';
        $statt = $this->Model->getOne('voiture_station',array('STATION_ID'=>$STATION_ID));
        $stat= ' ,station: '.$statt['STATION_NOM'];
      }
      else{
        $data['condstation'] = '';
        $stat= '';
      }
      $data['VEHICULE_IDS']= $this->input->post('VEHICULE_ID');
      if ($VEHICULE_ID !=NULL) {
        $data['condvehicle']='AND car.VEHICULE_ID ='.$VEHICULE_ID.' ';
        $voiture = $this->Model->getOne('voiture_vehicules',array('VEHICULE_ID'=>$VEHICULE_ID));
        $vehi = ', voiture '.$voiture['PLAQUE_VEHICULE'];
      }
      else{
        $data['condvehicle']='';
        $vehi = '';
      }

      if ($PERIODE != null) {
      $str = $PERIODE;
      $dat=explode(" - ",$str);

     $date1 = DateTime::createFromFormat('d/m/Y', $dat[0]);
     $debut = $date1->format('Y-m-d');
     $date2 = DateTime::createFromFormat('d/m/Y', $dat[1]);
     $fin = $date2->format('Y-m-d');
     $data['conditions'] = ' AND CONSOMATION_DATE BETWEEN "'.$debut.'" AND "'.$fin.'"';
     $selectdates = 'Entre '.$debut.' et '.$fin;
     $data['selectdate'] = $PERIODE;
      }
      else{
        $thismonth = date("Y-m");
        $selectdates = date("Y-m");
        $data['conditions'] = ' AND CONSOMATION_DATE LIKE "'.$thismonth.'%"';
        $data['selectdate'] = '';
      }

      $data['options'] = $this->input->post('options');
      $options = $this->input->post('options');
      if ($options == NULL) {
        // echo "NULL";
        $data['selection'] = NULL;
          $data['a0'] ='';
          $data['a1'] ='active';
          $data['a2'] ='';
          $data['a3'] ='';
          $data['a4'] =''; 
          $data['ac0'] ='';
          $data['ac1'] ='checked';
          $data['ac2'] ='';
          $data['ac3'] ='';
          $data['ac4'] ='';  

          
          $data['condition']='car.IS_PAYE = 0';
      }
      else{
        // echo "Quelque chose";
        $data['selection'] = $options;
        // echo $options;
        // echo "<br>";
        if ($options == 0) {
          $data['a0'] ='active';
          $data['a1'] ='';
          $data['a2'] ='';
          $data['a3'] ='';
          $data['a4'] ='';
          $data['ac0'] ='checked';
          $data['ac1'] ='';
          $data['ac2'] ='';
          $data['ac3'] ='';
          $data['ac4'] =''; 
          $data['condition']=' 1';
        }
        elseif ($options == 1) {
          $data['a0'] ='';
          $data['a1'] ='active';
          $data['a2'] ='';
          $data['a3'] ='';
          $data['a4'] ='';  
          $data['ac0'] ='';
          $data['ac1'] ='checked';
          $data['ac2'] ='';
          $data['ac3'] ='';
          $data['ac4'] =''; 
          $data['condition']='car.IS_PAYE = 0';        
        }
        elseif ($options == 2) {
          $data['a0'] ='';
          $data['a1'] ='';
          $data['a2'] ='active';
          $data['a3'] ='';
          $data['a4'] ='';
          $data['ac0'] ='';
          $data['ac1'] ='';
          $data['ac2'] ='checked';
          $data['ac3'] ='';
          $data['ac4'] =''; 
          $data['condition']='car.IS_PAYE = 1';
        }
        elseif ($options == 3) {
          $data['a0'] ='';
          $data['a1'] ='';
          $data['a2'] ='';
          $data['a3'] ='active';
          $data['a4'] ='';
          $data['ac0'] ='';
          $data['ac1'] ='';
          $data['ac2'] ='';
          $data['ac3'] ='checked';
          $data['ac4'] =''; 
          $data['condition']='car.ID_STATUS = 2';
        }
        elseif ($options == 4) {
          $data['a0'] ='';
          $data['a1'] ='';
          $data['a2'] ='';
          $data['a3'] ='';
          $data['a4'] ='active';
          $data['ac0'] ='';
          $data['ac1'] ='';
          $data['ac2'] ='';
          $data['ac3'] ='';
          $data['ac4'] ='checked'; 
          $data['condition']='car.ID_STATUS = 4 or car.ID_STATUS = 3';
        }


      }

    
      
        $data['selectdate'] = $PERIODE;
        $data['title'] = "Ravitaillement du carburant date: ".$selectdates." ".$vehi." ".$stat." ";
        $this->load->view('Mettre_Carburant_List_View',$data);

    }

  public function modifier()
  {
     $this->Is_permis();
     $CONSOMATION_ID =$this->uri->segment(4);
      $title = "Modification mise du carburant";
      $onedetail = $this->Model->getOne('voiture_carburant_consomation',array('CONSOMATION_ID'=>$CONSOMATION_ID));


      $lastkm = $this->Model->getOneOrder('voiture_carburant_consomation',array('VEHICULE_ID'=>$onedetail['VEHICULE_ID'],'ID_STATUS'=>1),'KM_A_APROVISIONNEMENT');

      if ($onedetail['PROVENANCEOUDESTINATION'] == 1) {
        $sel1 = 'checked="checked"';
        $sel2 = '';
      }
      else{
        $sel1 = '';
        $sel2 = 'checked="checked"';
      }


      $date=date_create($onedetail['CONSOMATION_DATE']);
      $ndate = date_format($date,"d/m/Y");
      
      $approvisionnement = array(
               'CONSOMATION_ID'=>$onedetail['CONSOMATION_ID'],                                   
               'NUM_GENERATED'=>$onedetail['NUM_GENERATED'],                                   
               'PATH_FACTURE'=>$onedetail['PATH_FACTURE'],                                   
               'CONSOMATION_DATE'=>$ndate,
               'VEHICULE_ID'=>$this->Model->getList('voiture_vehicules',array()), 
               'VEHICULE_IDSELECTED'=>$onedetail['VEHICULE_ID'],
               'STATION_ID'=>$this->Model->getList('voiture_station',array()), 
               'STATION_IDSELECTED'=>$onedetail['STATION_ID'],
               'CHAUFFEUR_ID'=>$this->Model->getList('rh_employe',array()), 
               'CHAUFFEUR_IDSELECTED'=>$onedetail['CHAUFFEUR_ID'],
               'QUANTITE_RECU'=>$onedetail['QUANTITE_RECU'], 
               // 'TRAJET_ID'=>$this->Model->getList('masque_trajet',array()), 
               'TRAJET_IDSELECTED'=>$onedetail['TRAJET_ID'],
               'MONTANT_CONSOMATION'=>$onedetail['MONTANT_CONSOMATION'], 
               'PRIX_UNITAIRE'=>$onedetail['PRIX_UNITAIRE'], 
               'KM_A_APROVISIONNEMENT_MIN'=>$lastkm['KM_A_APROVISIONNEMENT'], 
               'KM_A_APROVISIONNEMENT'=>$onedetail['KM_A_APROVISIONNEMENT'], 
               'PROVENANCEOUDESTINATION'=>$sel1 .' '.$sel2,
               'USERSAVER'=>$onedetail['USERSAVER'],
              );

        
        $data['title'] = $title;
        $data['approv'] = $approvisionnement;


    $this->load->view("Mettre_Carburant_Update_View",$data);
  }

  public function update_mettre_carburant()
  {

    $CONSOMATION_ID =$this->input->post('CONSOMATION_ID');
      $title = "Modification mise du carburant";
      $onedetail = $this->Model->getOne('voiture_carburant_consomation',array('CONSOMATION_ID'=>$CONSOMATION_ID));
      if ($onedetail['PROVENANCEOUDESTINATION'] == 1) {
        $sel1 = 'checked="checked"';
        $sel2 = '';
      }
      else{
        $sel1 = '';
        $sel2 = 'checked="checked"';
      }

      $date=date_create($onedetail['CONSOMATION_DATE']);
      $ndate = date_format($date,"d/m/Y");
      

      $lastkm = $this->Model->getOneOrder('voiture_carburant_consomation',array('VEHICULE_ID'=>$onedetail['VEHICULE_ID'],'ID_STATUS'=>1),'KM_A_APROVISIONNEMENT');

      $approvisionnement = array(
               'CONSOMATION_ID'=>$onedetail['CONSOMATION_ID'],                                   
               'NUM_GENERATED'=>$onedetail['NUM_GENERATED'],                                   
               'PATH_FACTURE'=>$onedetail['PATH_FACTURE'],                                   
               'CONSOMATION_DATE'=>$ndate,
               'VEHICULE_ID'=>$this->Model->getList('voiture_vehicules',array()), 
               'VEHICULE_IDSELECTED'=>$onedetail['VEHICULE_ID'],
               'STATION_ID'=>$this->Model->getList('voiture_station',array()), 
               'STATION_IDSELECTED'=>$onedetail['STATION_ID'],
               'CHAUFFEUR_ID'=>$this->Model->getList('rh_employe',array()), 
               'CHAUFFEUR_IDSELECTED'=>$onedetail['CHAUFFEUR_ID'],
               'QUANTITE_RECU'=>$onedetail['QUANTITE_RECU'], 
               // 'TRAJET_ID'=>$this->Model->getList('masque_trajet',array()), 
               'TRAJET_IDSELECTED'=>$onedetail['TRAJET_ID'],
               'MONTANT_CONSOMATION'=>$onedetail['MONTANT_CONSOMATION'], 
               'PRIX_UNITAIRE'=>$onedetail['PRIX_UNITAIRE'], 
               'KM_A_APROVISIONNEMENT_MIN'=>$lastkm['KM_A_APROVISIONNEMENT'], 
               'KM_A_APROVISIONNEMENT'=>$onedetail['KM_A_APROVISIONNEMENT'], 
               'PROVENANCEOUDESTINATION'=>$sel1 .' '.$sel2,
               'USERSAVER'=>$onedetail['USERSAVER'],
              );




     $myDateTime = DateTime::createFromFormat('d/m/Y', $this->input->post('CONSOMATION_DATE'));
     $newdate = $myDateTime->format('Y-m-d');

     $data = array(          
        'NUM_GENERATED'=>$this->input->post('NUM_GENERATED'),                                 
        'VEHICULE_ID'=>$this->input->post('VEHICULE_ID'),                                   
        'STATION_ID'=>$this->input->post('STATION_ID'),
        'QUANTITE_RECU'=>$this->input->post('QUANTITE_RECU'),
        // 'PROVENANCEOUDESTINATION'=>$this->input->post('PROVENANCEOUDESTINATION'),
        // 'TRAJET_ID'=>$this->input->post('TRAJET_ID'),
        'MONTANT_CONSOMATION'=>$this->input->post('MONTANT_CONSOMATION'),
        'PRIX_UNITAIRE'=>$this->input->post('PRIX_UNITAIRE'),
        'CONSOMATION_DATE'=>$newdate,
        'KM_A_APROVISIONNEMENT'=>$this->input->post('KM_A_APROVISIONNEMENT'),
        'CHAUFFEUR_ID'=>$this->input->post('CHAUFFEUR_ID'),
        'PATH_FACTURE'=>$this->input->post('PATH_FACTURE'),
        'USERSAVER'=>$this->input->post('USERSAVER'),
        'OLD_VALUE_ID'=>$CONSOMATION_ID,
        );
     
     $this->form_validation->set_rules('VEHICULE_ID', 'Vehicule', 'required');
     $this->form_validation->set_rules('STATION_ID', 'Station', 'required');
     $this->form_validation->set_rules('QUANTITE_RECU', 'Nb littre', 'required');
     // $this->form_validation->set_rules('TRAJET_ID', 'Provenance ou Destination', 'required');
     $this->form_validation->set_rules('MONTANT_CONSOMATION', 'Montant consomation', 'required');
     $this->form_validation->set_rules('PRIX_UNITAIRE', 'Prix unitaire', 'required');
     $this->form_validation->set_rules('CONSOMATION_DATE', 'Date facturation', 'required');
     $this->form_validation->set_rules('KM_A_APROVISIONNEMENT', 'Km approvisionnement', 'required');
     $this->form_validation->set_rules('CHAUFFEUR_ID', 'Chauffeur', 'required');

    //SI Valide
     if ($this->form_validation->run() == FALSE){        
        
        $title = "Mettre du carburant";

        $message = "<div class='alert alert-danger' id='message'>
                            Donne manquantes, Processus échoué.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";

        $data['title'] = $title;        
        $data['approv'] = $approvisionnement;
        $this->session->set_flashdata(array('message'=>$message));
       $this->load->view("Mettre_Carburant_Update_View",$data);

      }else{

        // print_r($data);
        // exit();
        $this->Model->insert_last_id('voiture_carburant_consomation',$data);
        $this->Model->update('voiture_carburant_consomation',array('CONSOMATION_ID'=>$CONSOMATION_ID),array('ID_STATUS'=>2,'USERCHANGER'=>$this->session->userdata('SOCAR_ID_USER') ));
        
          $message = "<div class='alert alert-success'  id='message'>
                            Modification fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Mettre_Carburant/listing'));
      }
  }

  public function suppimer()
  {
    $this->Is_permis();
    $CONSOMATION_ID = $this->uri->segment(4);
    // echo $CONSOMATION_ID;
    // exit();
// annuler suppimer
    $detail = $this->Model->update('voiture_carburant_consomation',array('CONSOMATION_ID'=>$CONSOMATION_ID),array('ID_STATUS'=>3,'USERDELETE'=>$this->session->userdata('SOCAR_ID_USER')));

    $message = "<div class='alert alert-success'  id='message'>
                            Suppression fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Mettre_Carburant/listing'));
  }

  public function annuler()
  {
    $CONSOMATION_ID = $this->uri->segment(4);
    // echo $CONSOMATION_ID;
    // exit();
// annuler suppimer
    $detail = $this->Model->update('voiture_carburant_consomation',array('CONSOMATION_ID'=>$CONSOMATION_ID),array('ID_STATUS'=>4,'USERANNULE'=>$this->session->userdata('SOCAR_ID_USER')));

    $message = "<div class='alert alert-success'  id='message'>
                            Annullation fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Mettre_Carburant/listing'));
  }


  
  public function paye()
  {
    $CONSOMATION_ID = $this->uri->segment(4);
    // echo $CONSOMATION_ID;
    // exit();
// annuler suppimer
    $detail = $this->Model->update('voiture_carburant_consomation',array('CONSOMATION_ID'=>$CONSOMATION_ID),array('IS_PAYE'=>1,'USERPAYE'=>$this->session->userdata('SOCAR_ID_USER')));

    $message = "<div class='alert alert-success'  id='message'>
                            Paiement fait avec succès.
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";       
        $this->session->set_flashdata(array('message'=>$message));
        redirect(base_url('voiture/Mettre_Carburant/listing'));
  }
 }


?>