<?php 
 /**
  * 
  */
 class Retour_Vente extends CI_Controller
 {

  function __construct()
  {
    parent::__construct();
    $this->load->library('Mylibrary');
    $this->ci = & get_instance();
    $this->ci->load->library("user_agent");
    // $this->Is_Connected();
    // $this->verification();

  }

  public function Is_Connected()
  {

   if (empty($this->session->userdata('SOCAR_ID_USER')))
   {
     redirect(base_url('Login/'));
   }
 }


 public function index()
 {

  $data['title'] = "Retour Vente";
  $this->load->view('Retour_Vente_Add_View',$data);

}

public function listing()
{

  $data['title'] = "Retour Vente";
  $this->load->view('Retour_Vente_List_View',$data);

}

public function retourv()
{
  $idVenteDetails = $this->input->post('ID_VENTE_DETAILS');
  $quantiteRetourne = $this->input->post('QUANTITE_RETOURNE');
  $ID_MOTIF_RETOUR = $this->input->post('ID_MOTIF_RETOUR');
  $COMMENTAIRE = $this->input->post('COMMENTAIRE');

  $vent = $this->Model->getOne('vente_details', array('ID_VENTE_DETAILS' => $idVenteDetails));

  if($quantiteRetourne <= $vent['QUANTITE_LIVRE'] ){

    $quantiteRestant=$vent['QUANTITE_LIVRE'] - $quantiteRetourne;
    $prixRestant=$quantiteRestant*$vent['PRIX_UNITAIRE'];

    $updateResult = $this->Model->update('vente_details', 
      array('ID_VENTE_DETAILS' => $idVenteDetails), 
      array('QUANTITE_RETOURNE' => $quantiteRetourne,'QUANTITE_LIVRE' => $quantiteRestant,'ID_MOTIF_RETOUR' => $ID_MOTIF_RETOUR,'COMMENTAIRE' => $COMMENTAIRE)
    );

    $this->Model->insert_last_id('retour_historique',['ID_VENTE'=>$vent['ID_VENTE'],'ID_VENTE_DETAIL'=>$idVenteDetails,'QUANTITE'=>$quantiteRetourne,'ID_VENTE_STATUT'=>$vent['ID_VENTE_STATUT']]);
           // Vérifier si la vente doit être mise à jour
    $orga = $this->Model->checkvalue('vente_details', [
      'ID_VENTE' => $vent['ID_VENTE'],
      'ID_STATUS' => 2,
      'QUANTITE_RETOURNE' => NULL
    ]);

    if(!$orga){
     $this->Model->update('vente_vente', 
      array('ID_VENTE' => $vent['ID_VENTE']), 
      array('MONTANT_PAYE' =>$prixRestant ,'DATE_RETOUR' => date('Y-m-d'))
    );
   }
   

   echo '1';
 } else {
  echo '2'; 
}
}

public function retour_vente()
{
    // Retrieve the selected IDs and quantities from the form
    $selectedIds = $this->input->post('SELECT'); // Get selected IDs
    $quantiteRetourne = $this->input->post('QUANTITE_LIVRE');
    $ID_MOTIF_RETOUR = $this->input->post('ID_MOTIF_RETOUR');
    $COMMENTAIRE = $this->input->post('COMMENTAIRE');
    $prixRestant=0;

    // Check if any IDs were selected
    if (!empty($selectedIds) && is_array($selectedIds)) {
      foreach ($selectedIds as  $idVenteDetails) {
        $quantite = isset($quantiteRetourne[$idVenteDetails]) ? $quantiteRetourne[$idVenteDetails] : 0;

        $vent = $this->Model->getOne('vente_details', ['ID_VENTE_DETAILS' => $idVenteDetails]);

        if ($quantite > 0 && $quantite <= $vent['QUANTITE_LIVRE']) {
          $quantiteRestant = $vent['QUANTITE_LIVRE'] - $quantite;
          $prixRestant += $quantiteRestant * $vent['PRIX_UNITAIRE'];

          $this->Model->update(
            'vente_details',
            ['ID_VENTE_DETAILS' => $idVenteDetails],
            [
              'QUANTITE_RETOURNE' => $quantite,
              'QUANTITE_LIVRE' => $quantiteRestant,
              'ID_MOTIF_RETOUR' => $ID_MOTIF_RETOUR,
              'COMMENTAIRE' => $COMMENTAIRE
            ]
          );

        }

      }


      $orga = $this->Model->checkvalue('vente_details', [
        'ID_VENTE' => $vent['ID_VENTE'],
        'QUANTITE_LIVRE >' => 0,
        'QUANTITE_RETOURNE' => NULL
      ]);


      $orga = $this->Model->checkvalue('vente_details', [
        'ID_VENTE' => $vent['ID_VENTE'],
        'QUANTITE_LIVRE >' => 0,
        'QUANTITE_RETOURNE' => NULL
      ]);

      $commune_livre = $this->Model->getRequete("SELECT `ID_VENTE_DETAILS`, vente_details.ID_TAILLE_BOUTEILLE, syst_taille_bouteille.DESCRIPTION,QUANTITE_LIVRE,QUANTITE_RETOURNE, `QUANTITE_COMMANDE`, `PRIX_UNITAIRE`, vente_details.ID_STATUS FROM `vente_details` JOIN syst_taille_bouteille ON syst_taille_bouteille.ID_TAILLE_BOUTEILLE = vente_details.ID_TAILLE_BOUTEILLE WHERE QUANTITE_RETOURNE IS  NULL AND  vente_details.ID_STATUS=2 AND `ID_VENTE` = ".$vent['ID_VENTE']."");

      $totalpay = 0;
      if(!empty($commune_livre)){
       foreach ($commune_livre as $commun) {
         $totalpay+= $commun["QUANTITE_LIVRE"]*$commun["PRIX_UNITAIRE"];
       }
     }

      $montant=$totalpay <= 0 ?  $prixRestant :  $prixRestant+$totalpay;


     if(!$orga){
      $this->Model->update(
        'vente_vente',
        ['ID_VENTE' => $vent['ID_VENTE']],
        [
          'MONTANT_PAYE' => $montant,
          'DATE_RETOUR' => date('Y-m-d')
        ]
      );
    }else{
     $this->Model->update(
      'vente_vente',
      ['ID_VENTE' => $vent['ID_VENTE']],
      [
        'MONTANT_PAYE' => $montant,
      ]
    );
   }



        // Set success message
   $message = "<div class='alert alert-success' id='message'>
   Enregistrement fait avec succès.
   <button type='button' class='close' data-dismiss='alert'>&times;</button>
   </div>";
   $this->session->set_flashdata(['message' => $message]);
 } else {
        // Set error message if no items were selected
  $message = "<div class='alert alert-danger' id='message'>
  Aucun élément sélectionné ou quantité invalide.
  <button type='button' class='close' data-dismiss='alert'>&times;</button>
  </div>";
  $this->session->set_flashdata(['message' => $message]);
}

    // Redirect to the vente page
redirect(base_url('vente/Retour_Vente'));
}


}                        