<?php 
 /**
  * 
  */
 class Vente extends CI_Controller
 {

  function __construct()
  {
    parent::__construct();
    $this->load->library('Mylibrary');
    $this->ci = & get_instance();
    $this->ci->load->library("user_agent");
    // $this->Is_Connected();
    // $this->verification();

  }

  public function Is_Connected()
  {

   if (empty($this->session->userdata('SOCAR_ID_USER')))
   {
     redirect(base_url('Login/'));
   }
 }



 public function index()
 {

  $data['title'] = "Vente & Livraison";
  $data['lot']=$this->Model->getList('prod_lot',array('ID_STATUS'=>1));
  $this->load->view('Vente_Add_View',$data);

}

public function listing()
{

  $data['title'] = "Vente & Livraison";
  $this->load->view('Vente_List_View',$data);

}


public function livraison() {
  // header('Content-Type: application/json');

  $ID_VENTE_DETAILS = $this->input->post('ID_VENTE_DETAILS');
  $QUANTITE_LIVRE = $this->input->post('QUANTITE_LIVRE');
  $PRIX_UNITAIRE = $this->input->post('PRIX_UNITAIRE');
  $ID_TAILLE_BOUTEILLE = $this->input->post('ID_TAILLE_BOUTEILLE');

  $qte_livre = ($ID_TAILLE_BOUTEILLE == 1) ? $QUANTITE_LIVRE * 12 :
  (($ID_TAILLE_BOUTEILLE == 2) ? $QUANTITE_LIVRE * 6 : $QUANTITE_LIVRE);

    // Récupérer les détails de la vente
  $vent = $this->Model->getOne('vente_details', ['ID_VENTE_DETAILS' => $ID_VENTE_DETAILS]);


  $data = [
    'DATE_SORTIE_STOCK' => date('Y-m-d'),
    'QUANTITE' => $qte_livre,
    'ID_TYPE_BOUTEILLE' => 2,
    'ID_TAILLE_BOUTEILLE' => $vent['ID_TAILLE_BOUTEILLE'],
    'ID_USER' => $this->session->userdata('SOCAR_ID_USER'),
  ];

    // Vérifier la quantité en stock
  $stockac = $this->Model->getOne('stock_stock', [
    'ID_TYPE_BOUTEILLE' => 2,
    'ID_TAILLE_BOUTEILLE' => $vent['ID_TAILLE_BOUTEILLE']
  ]);

    // Vérifier si la quantité en stock est suffisante
  if ($stockac['QUANTITE'] >= $qte_livre) {
        // Insérer la sortie de stock
    $estock = $this->Model->insert_last_id('stock_sortie_stock', $data);

    if ($estock) {
            // Mettre à jour les détails de la vente
      $this->Model->update('vente_details', [
        'ID_VENTE_DETAILS' => $ID_VENTE_DETAILS
      ], [
        'ID_STATUS' => 2,
        'QUANTITE_LIVRE' => $QUANTITE_LIVRE,
        'PRIX_UNITAIRE' => $PRIX_UNITAIRE
      ]);

            // Mettre à jour le stock
      $this->Model->update('stock_stock', [
        'ID_TYPE_BOUTEILLE' => 2,
        'ID_TAILLE_BOUTEILLE' => $vent['ID_TAILLE_BOUTEILLE']
      ], [
        'QUANTITE' => $stockac['QUANTITE'] - $qte_livre
      ]);
    }

        // Vérifier si la vente doit être mise à jour
    $orga = $this->Model->checkvalue('vente_details', [
      'ID_VENTE' => $vent['ID_VENTE'],
      'ID_STATUS' => 1,
      'QUANTITE_LIVRE' => NULL
    ]);

    if (!$orga) {
      $this->Model->update('vente_vente', [
        'ID_VENTE' => $vent['ID_VENTE']
      ], [
        'ID_VENTE_STATUT' => 2,
        'DATE_LIVRAISON' => date('Y-m-d')
      ]);
    }

    echo '1';
    // echo json_encode(['status' => 1]);

  } else {

    echo '2';
    // echo json_encode(['status' => 2]);
  }
}

// Méthode pour sauvegarder les éléments sélectionnés
public function saveSelectedItems() {
  $selectedItems = $this->input->post('selected_items');

  $dataToSave = [];
  $montapaye=0;
  $quantite=0;
  if (!empty($selectedItems)) {
    foreach ($selectedItems as $itemId) {
      $prixUnitaire = $this->input->post('PRIX_UNITAIRE')[$itemId] ?? 0;
      $quantiteCommande = $this->input->post('QUANTITE_COMMANDE')[$itemId] ?? 0; 
      $montapaye+=$quantiteCommande*$prixUnitaire;
      
      $dataToSave = [
        'PRIX_UNITAIRE' => $prixUnitaire,
        'QUANTITE_LIVRE' => $quantiteCommande,
        'ID_STATUS' => 2,
      ];
      $this->Model->update('vente_details', ['ID_VENTE_DETAILS' => $itemId], $dataToSave);

            // Récupérer les détails de la vente
      $vent = $this->Model->getOne('vente_details', ['ID_VENTE_DETAILS' => $itemId]);
    }


    $orga = $this->Model->checkvalue('vente_details', [
      'ID_VENTE' => $vent['ID_VENTE'],
      'ID_STATUS' => 1,
      'QUANTITE_LIVRE' => NULL
    ]);

    if (!$orga) {
     $donne_paie = $this->Model->getOne('vente_vente', [
      'ID_VENTE' => $vent['ID_VENTE'],
    ]);

     $this->Model->update('vente_vente', [
      'ID_VENTE' => $vent['ID_VENTE']
    ], [
      'ID_VENTE_STATUT' => 2,
      'MONTANT_PAYE' => $donne_paie['MONTANT_PAYE'] ? $donne_paie['MONTANT_PAYE']+ $montapaye : $montapaye,
      'DATE_LIVRAISON' => date('Y-m-d')
    ]);
   }else{
     $this->Model->update('vente_vente', [
      'ID_VENTE' => $vent['ID_VENTE']
    ], [
      'MONTANT_PAYE' => $montapaye,
      'ID_VENTE_STATUT' =>3,
    ]);
   }

   
   $message = "<div class='alert alert-success' id='message'>
   Enregistrement fait avec succès.
   <button type='button' class='close' data-dismiss='alert'>&times;</button>
   </div>"; 
   $this->session->set_flashdata(array('message' => $message));  
   redirect(base_url('vente/Vente'));
 } else {
  $message = "<div class='alert alert-danger' id='message'>
  Aucun élément sélectionné.
  <button type='button' class='close' data-dismiss='alert'>&times;</button>
  </div>"; 
  $this->session->set_flashdata(array('message' => $message));
  redirect(base_url('vente/Vente'));
}
}


}                        