<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Contact_Back extends CI_Controller {

    public function __construct() {
        parent::__construct();
    }

    public function index()
    {  
    	$messages = $this->Model->getRequete("SELECT ct.*,cst.* FROM contacts as ct 
    		                                JOIN contact_statut as cst 
    		                                ON cst.statut_id = ct.statut_id 
    		                                ORDER BY ct.contact_id DESC");
        
        $array_message = array();
        foreach ($messages as $message) {
          $sub_array = NULL;
          $sub_array[] = $message['nom'];
          $sub_array[] = $message['email'];
          $sub_array[] = $message['subjet'];
          $sub_array[] = $message['message'];
          $sub_array[] = "<span class='text-".$message['color']."'>".$message['statut_descr']."</span>";
          $OPTIONS = '<div class="dropdown ">
                         <a class="btn btn-primary btn-sm dropdown-toggle" data-toggle="dropdown">
                               <font color="white">Actions</font>
                               <span class="caret"></span>
                         </a>
                         <ul class="dropdown-menu dropdown-menu-right">
                        ';
          $OPTIONS .= "<li style='margin-left:30px'>
                        <a href='".base_url('chambre/Contact_Back/repondre/'.$message['contact_id'])."'>
                          <i class='fa fa-envelope' aria-hidden='true' ></i> repondre</a>
                       </li>
                      </ul>
                     </div>";
          $sub_array[] = $OPTIONS;

          $array_message[] = $sub_array;
        }
        $template = array(
            'table_open' => '<table id="messages" class="table table-bordered table-striped">',
            'table_close' => '</table>'
        );
        $this->table->set_template($template);
        $this->table->set_heading(array('NOM','EMAIL','SUBJECT','MESSAGE','STATUT','OPTION'));

    	$data['title'] = "Messages du public";
    	$data['messages'] = $array_message; 
       $this->load->view('Contact_Back_View',$data);
    }

    function repondre(){
        $contact_id = $this->uri->segment(4);
        $mon_contact = $this->Model->getOne('contacts',array('contact_id'=>$contact_id));
        $reponses = $this->Model->getList('contacts_histo',array('contact_id'=>$contact_id));

        $data['title'] = "Répondre le message de <b>".$mon_contact['nom']."</b> du ".$mon_contact['date_insertion'];
    	$data['reponses'] = $reponses; 
    	$data['contact'] = $mon_contact; 
       $this->load->view('Contact_Reponse_Back_View',$data);	
    }

    function reponse_save(){
      $this->form_validation->set_rules('message', 'Message', 'required');
      if ($this->form_validation->run() == FALSE){
        $contact_id = $this->input->post('contact_id');
        $mon_contact = $this->Model->getOne('contacts',array('contact_id'=>$contact_id));
        $reponses = $this->Model->getList('contacts_histo',array('contact_id'=>$contact_id));

        $data['title'] = "Répondre le message de <b>".$mon_contact['nom']."</b> du ".$mon_contact['date_insertion'];
    	$data['message'] = $this->input->post('message'); 
    	$data['reponses'] = $reponses; 
    	$data['contact'] = $mon_contact; 
       $this->load->view('Contact_Reponse_Back_View',$data);	
      }else{
      	 $contact_id = $this->input->post('contact_id');
         $response = $this->input->post('message');

         $array_histo = array(
         	              'contact_id'=>$contact_id,
         	              'response'=>$response,
         	              'user_id'=>1,
         	          ); 
         $histo = $this->Model->insert_last_id('contacts_histo',$array_histo);

         $this->Model->update('contacts',array('contact_id' =>$contact_id),array('statut_id'=>2));
         redirect(base_url('chambre/Contact_Back/repondre/'.$contact_id));
      }
    }
}