<?php
  include VIEWPATH.'includes/new_header.php';
  include VIEWPATH.'includes/new_top_menu.php';
  include VIEWPATH.'includes/new_menu_principal.php';
  ?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <?php
    include 'includes/Menu_Dashboard_Stock.php';
    ?>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- left column -->
          <div class="col-md-12">
            <!-- jquery validation -->
            <div class="card card-primary">
              <div class="card-header">
                <!-- <h3 class="card-title">Tabl des menu & articles</h3> -->
              </div>
              <!-- /.card-header -->
              <!-- form start -->

 <div class="card-body row">

<div class="col-md-6" id="containertree"></div>
<div class="col-md-6" id="containerfour"></div>
<div class="col-md-6" id="containerone"></div>
<div class="col-md-6" id="containertwo"></div>

       

          </div> 
            </div>
            <!-- /.card -->
            </div>
          <!--/.col (left) -->
          <!-- right column -->
          
          <!--/.col (right) -->
        </div>
        <!-- /.row -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>



  <?php
  include VIEWPATH.'includes/new_copy_footer.php';
  ?>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->
<?php
  include VIEWPATH.'includes/new_script.php';
  ?>
<script>
  $(document).ready(function(){ 
    $('#message').delay(5000).hide('slow');
    });
</script>

<script type="text/javascript">
Highcharts.chart('containerone', {
    chart: {
        type: 'line'
    },
    title: {
        text: 'Mouvement du stock'
    },
    subtitle: {
        text: 'Nombre d\'articles'
    },
    xAxis: {
        categories: [<?php echo $xaxis;?>]
    },
    yAxis: {
        title: {
            text: 'nb articles'
        }
    },
    plotOptions: {
        line: {
            dataLabels: {
                enabled: true
            },
            enableMouseTracking: true
        }
    },
    credits :{
      enabled: true,
        text: 'Développé par Prime Entreprises',
        href:'#'
    },
    series: [{
        name: 'Entree',
        data: [<?php echo $nbentree;?>]
    }, {
        name: 'Sortie',
        data: [<?php echo $nbsortie;?>]
    },
    {
        name: 'Transfert',
        data: [<?php echo $nbtransf;?>]
    },
    {
        name: 'Pertes',
        data: [<?php echo $nbperte;?>]
    }]
});


Highcharts.chart('containertwo', {
    chart: {
        type: 'line'
    },
    title: {
        text: 'Mouvement du stock'
    },
    subtitle: {
        text: 'Valeur monétaire des articles'
    },
    xAxis: {
        categories: [<?php echo $xaxis;?>]
    },
    yAxis: {
        title: {
            text: 'Fbu'
        }
    },
    plotOptions: {
        line: {
            dataLabels: {
                enabled: true
            },
            enableMouseTracking: true
        }
    },
    credits :{
      enabled: true,
        text: 'Développé par Prime Entreprises',
        href:'#'
    },
    series: [{
        name: 'Entree',
        data: [<?php echo $mtentree; ?>]
    }, {
        name: 'Sortie',
        data: [<?php echo $mtsortie; ?>]
    },
    {
        name: 'Transfert',
        data: [<?php echo $mttransf; ?>]
    },
    {
        name: 'Pertes',
        data: [<?php echo $mtperte; ?>]
    }]
});



Highcharts.chart('containertree', {
    chart: {
        plotBackgroundColor: null,
        plotBorderWidth: null,
        plotShadow: false,
        type: 'pie'
    },
    title: {
        text: 'Répartition  des articles actuellement au stock'
    },
    subtitle: {
        text: '% par section'
    },
    tooltip: {
        pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
    },
    accessibility: {
        point: {
            valueSuffix: '%'
        }
    },
    plotOptions: {
        pie: {
            allowPointSelect: true,
            cursor: 'pointer',
            dataLabels: {
                enabled: true,
                format: '<b>{point.name}</b>: {point.percentage:.1f} %'
            }
        }
    },
    credits :{
      enabled: true,
        text: 'Développé par Prime Entreprises',
        href:'#'
    },
    series: [{
        name: 'Brands',
        colorByPoint: true,
        data: [<?php echo $dataserietree ?>]
    }]
});

Highcharts.chart('containerfour', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'Top 10 des articles avec moin d\'articles '
    },
    subtitle: {
        text: 'nb par articles'
    },
    xAxis: {
        type: 'category',
        labels: {
            rotation: -45,
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            }
        }
    },
    yAxis: {
        min: 0,
        title: {
            text: 'Nb articles'
        }
    },
    credits :{
      enabled: true,
        text: 'Développé par Prime Entreprises',
        href:'#'
    },
    legend: {
        enabled: false
    },
    tooltip: {
        pointFormat: 'Nb articles =  <b>{point.y:.1f}</b>'
    },
    series: [{
        name: 'Articles',
        data: [
            <?php echo $dataseriefour; ?>
        ],
        dataLabels: {
            enabled: true,
            rotation: -90,
            color: '#FFFFFF',
            align: 'right',
            format: '{point.y:.1f}', // one decimal
            y: 10, // 10 pixels down from the top
            style: {
                fontSize: '13px',
                fontFamily: 'Verdana, sans-serif'
            }
        }
    }]
});

</script>

</body>
</html>
