<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Type_Client extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->Is_Connected();
    }

public function Is_Connected()
       {

       if (empty($this->session->userdata('PEA_USER_ID')))
        {
         redirect(base_url('Login/'));
        }
       }

    public function index()
    {
      $data['title']=' Type Client';
      $data['stitle']=' Type Client';
      $this->load->view('Type_Client_Add_View',$data);
    }


    public function add()
  {

   $DESCRIPTION=$this->input->post('DESCRIPTION');
   $this->form_validation->set_rules('DESCRIPTION', 'Nom', 'required');
   
   if ($this->form_validation->run() == FALSE){
    $message = "<div class='alert alert-danger' id='message'> Type de Client non enregistr&eacute; <button type='button' class='close' data-dismiss='alert'>&times;</button> </div>";
    $this->session->set_flashdata(array('message'=>$message));
    $data['title']=' Type Client';
    $data['stitle']=' Type Client';
    $this->load->view("Type_Client_Add_View",$data);
   }
   else{

    $datas=array('DESCRIPTION'=>$DESCRIPTION);
    $this->Model->insert_last_id('masque_type_client',$datas);
    $message = "<div class='alert alert-success' id='message'>
                            Type de Client enregistr&eacute; avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('saisie/Type_Client/listing'));    

   }
    }

     public function listing()
    {

      $resultat=$this->Model->getRequete('SELECT * from masque_type_client');
      $tabledata=array();
      
      foreach ($resultat as $key) 
         {

          if ($key['STATUS'] == 1) {
            $stat = 'Actif';
            $fx = 'desactiver';
            $col = 'btn-danger';
            $titr = 'Désactiver';
            $stitr = 'voulez-vous désactiver ce type de Client ';
            $bigtitr = 'Désactivation de ce type de Client';
          }
          else{
            $stat = 'Innactif';
            $fx = 'reactiver';
            $col = 'btn-success';
            $titr = 'Réactiver';
            $stitr = 'voulez-vous réactiver ce type de Client ';
            $bigtitr = 'Réactivation de ce type de Client';
          }

          $nbclient=$this->Model->getRequeteOne('SELECT count(ID_TYPE_CLIENT) as NB_CLIENT from masque_clients WHERE ID_TYPE_CLIENT='.$key['ID_TYPE_CLIENT'].' ');
          $chambr=array();
          $chambr[]=$key['DESCRIPTION'];
          $chambr[]=$nbclient['NB_CLIENT'];  
          $chambr[]=$stat;  
          $chambr[]='<div class="modal fade" id="desactcat'.$key['ID_TYPE_CLIENT'].'" tabindex="-1" role="dialog" aria-labelledby="basicModal" aria-hidden="true">
  <div class="modal-dialog modal-sm">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel">'.$bigtitr.'</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <h6><b>Mr/Mme , </b> '.$stitr.' ('.$key['DESCRIPTION'].')?</h6>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
        <a href="'.base_url('saisie/Type_Client/'.$fx.'/'.$key['ID_TYPE_CLIENT']).'" class="btn '.$col.'">'.$titr.'</a>
      </div>
    </div>
  </div>
</div>

          <div class="dropdown ">
                    <a class="btn btn-primary btn-sm dropdown-toggle" data-toggle="dropdown">Actions
                    <span class="caret"></span></a>
                    <ul class="dropdown-menu dropdown-menu-right">
                    <li><a class="dropdown-item" href="'.base_url('saisie/Type_Client/details/'.$key['ID_TYPE_CLIENT']).'"> Details et Historique </a> </li>
                    <li><a class="dropdown-item" href="'.base_url('saisie/Type_Client/index_update/'.$key['ID_TYPE_CLIENT']).'"> Modifier </a> </li>
                    <li><a class="dropdown-item" href="#" data-toggle="modal" data-target="#desactcat'.$key['ID_TYPE_CLIENT'].'"> '.$titr.' </a> </li>
                    </ul>
                  </div>';

       $tabledata[]=$chambr;
     
     }

        $template = array(
            'table_open' => '<table id="mytable" class="table table-bordered table-striped">',
            'table_close' => '</table>'
        );
        $this->table->set_template($template);
        $this->table->set_heading(array('Type','Nb Client','Etat','Option'));
        $data['title'] = " Type de Client";
        $data['stitle']=' Type Client';
        $data['chamb']=$tabledata;
        $this->load->view('Type_Client_List_View',$data);

    }


    public function index_update($id)
    {
      $data['title']=' Type Client';
      $data['stitle']=' Type Client';
      $data['selected']=$this->Model->getOne('masque_type_client',array('ID_TYPE_CLIENT'=>$id));
      $this->load->view('Type_Client_Update_View',$data);
    }



    public function update()
  {

   $DESCRIPTION=$this->input->post('DESCRIPTION');
   $ID_TYPE_CLIENT=$this->input->post('ID_TYPE_CLIENT');
   $this->form_validation->set_rules('DESCRIPTION', 'Nom', 'required');
   if ($this->form_validation->run() == FALSE){
    $message = "<div class='alert alert-danger' id='message'> Type de Client non mis &agrave; jour <button type='button' class='close' data-dismiss='alert'>&times;</button> </div>";
    $this->session->set_flashdata(array('message'=>$message));
    $data['title']=' Type Client';
    $data['stitle']=' Type Client';
    $data['selected']=$this->Model->getOne('masque_type_client',array('ID_TYPE_CLIENT'=>$ID_TYPE_CLIENT));
    $this->load->view("Type_Client_Update_View",$data);
   }
   else{
    $datas=array('DESCRIPTION'=>$DESCRIPTION);
    $this->Model->update('masque_type_client',array('ID_TYPE_CLIENT'=>$ID_TYPE_CLIENT),$datas);
    $message = "<div class='alert alert-success' id='message'>
                            Type de Client mis a jour avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('saisie/Type_Client/listing'));    

   }
    }


  public function desactiver($id)
    {
      $this->Model->update('masque_type_client',array('ID_TYPE_CLIENT'=>$id),array('STATUS'=>0));
      $message = "<div class='alert alert-success' id='message'>
                            Type de Client désactivé avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
      $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('saisie/Type_Client/listing')); 
    }

  public function reactiver($id)
    {
      $this->Model->update('masque_type_client',array('ID_TYPE_CLIENT'=>$id),array('STATUS'=>1));
      $message = "<div class='alert alert-success' id='message'>
                            Type de Client Réactivé avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
      $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('saisie/Type_Client/listing')); 
    }

    public function details()
    {
      $data['title']=' Type de Client';
      $data['stitle']=' Type de Client';
      $this->load->view('Type_Client_Details_View',$data);
    }




}
?>