<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Type_Service extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->Is_Connected();
    }

public function Is_Connected()
       {

       if (empty($this->session->userdata('PEA_USER_ID')))
        {
         redirect(base_url('Login/'));
        }
       }

    public function index()
    {
      $data['title']=' Type Service';
      $data['stitle']=' Type Service';
      $this->load->view('Type_Service_Add_View',$data);
    }


    public function add()
  {

   $DESCRIPTION=$this->input->post('DESCRIPTION'); 
   $this->form_validation->set_rules('DESCRIPTION','Description', 'trim|required|is_unique[serv_type_service.DESCRIPTION]',array('required'=>'<font style="color:red;size:2px;">La description est obligatoire</font>','is_unique'=>'<font style="color:red;size:2px;">La description est unique</font>'));

   $this->form_validation->set_rules('PRIX','Prix', 'trim|required',array('required'=>'<font style="color:red;size:2px;">Le prix est obligatoire</font>'));



   if ($this->form_validation->run() == FALSE){
    $message = "<div class='alert alert-danger' id='message'> Type de Service non enregistr&eacute; <button type='button' class='close' data-dismiss='alert'>&times;</button> </div>";
    $this->session->set_flashdata(array('message'=>$message));
    $data['title']=' Type Service';
    $data['stitle']=' Type Service';
    $this->load->view("Type_Service_Add_View",$data);
   }
   else{

    $datas=array('DESCRIPTION'=>$DESCRIPTION,'MONTANT_ACHAT'=>$this->input->post('PRIX'));
    $this->Model->insert_last_id('serv_type_service',$datas);
    $message = "<div class='alert alert-success' id='message'>
                            Type de Service enregistr&eacute; avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('service/Type_Service/listing'));    

   }
    }

     public function listing()
    {

      $resultat=$this->Model->getRequete('SELECT * from serv_type_service');
      $tabledata=array();
      
      foreach ($resultat as $key) 
         {

          if ($key['STATUS'] == 1) {
            $stat = 'Actif';
            $fx = 'desactiver';
            $col = 'btn-danger';
            $titr = 'Désactiver';
            $stitr = 'voulez-vous désactiver ce type de Service ';
            $bigtitr = 'Désactivation de ce type de Service';
          }
          else{
            $stat = 'Innactif';
            $fx = 'reactiver';
            $col = 'btn-success';
            $titr = 'Réactiver';
            $stitr = 'voulez-vous réactiver ce type de Service ';
            $bigtitr = 'Réactivation de ce type de Service';
          }

         
          $chambr=array();
          $chambr[]=$key['DESCRIPTION'];
          if(!empty($key['MONTANT_ACHAT'])) {
           $chambr[]=$key['MONTANT_ACHAT']. " BIF"; 
          }else{
           $chambr[]="-"; 
          }

          
          $chambr[]=$stat;  
          $chambr[]='<div class="modal fade" id="desactcat'.$key['ID_TYPE_SERVICE'].'" tabindex="-1" role="dialog" aria-labelledby="basicModal" aria-hidden="true">
  <div class="modal-dialog modal-sm">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel">'.$bigtitr.'</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <h6><b>Mr/Mme , </b> '.$stitr.' ('.$key['DESCRIPTION'].')?</h6>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
        <a href="'.base_url('service/Type_Service/'.$fx.'/'.$key['ID_TYPE_SERVICE']).'" class="btn '.$col.'">'.$titr.'</a>
      </div>
    </div>
  </div>
</div>

          <div class="dropdown ">
                    <a class="btn btn-primary btn-sm dropdown-toggle" data-toggle="dropdown">Actions
                    <span class="caret"></span></a>
                    <ul class="dropdown-menu dropdown-menu-right">
                    
                    <li><a class="dropdown-item" href="'.base_url('service/Type_Service/index_update/'.$key['ID_TYPE_SERVICE']).'"> Modifier </a> </li>
                    <li><a class="dropdown-item" href="#" data-toggle="modal" data-target="#desactcat'.$key['ID_TYPE_SERVICE'].'"> '.$titr.' </a> </li>
                    </ul>
                  </div>';

       $tabledata[]=$chambr;
     
     }

        $template = array(
            'table_open' => '<table id="mytable" class="table table-bordered table-striped ">',
            'table_close' => '</table>'
        );
        $this->table->set_template($template);
        $this->table->set_heading(array('Type','Montant','Etat','Option'));
        $data['title'] = " Type de Service";
        $data['stitle']=' Type Service';
        $data['chamb']=$tabledata;
        $this->load->view('Type_Service_List_View',$data);

    }


    public function index_update($id)
    {
      $data['title']=' Type Service';
      $data['stitle']=' Type Service';
      $data['selected']=$this->Model->getOne('serv_type_service',array('ID_TYPE_SERVICE'=>$id));
      $this->load->view('Type_Service_Update_View',$data);
    }



    public function update()
  {

   $DESCRIPTION=$this->input->post('DESCRIPTION');
   $ID_TYPE_SERVICE=$this->input->post('ID_TYPE_SERVICE');
   $this->form_validation->set_rules('DESCRIPTION', 'Nom', 'required');
    $this->form_validation->set_rules('PRIX','Prix', 'trim|required',array('required'=>'<font style="color:red;size:2px;">Le prix est obligatoire</font>'));


   if ($this->form_validation->run() == FALSE){
    $message = "<div class='alert alert-danger' id='message'> Type de Service non mis &agrave; jour <button type='button' class='close' data-dismiss='alert'>&times;</button> </div>";
    $this->session->set_flashdata(array('message'=>$message));
    $data['title']=' Type Service';
    $data['stitle']=' Type Service';
    $data['selected']=$this->Model->getOne('serv_type_service',array('ID_TYPE_SERVICE'=>$ID_TYPE_SERVICE));
    $this->load->view("Type_Service_Update_View",$data);
   }
   else{
    $exist=$this->Model->getOne('serv_type_service',array('ID_TYPE_SERVICE!='=>$ID_TYPE_SERVICE,'DESCRIPTION'=>$DESCRIPTION));

if(empty($exist)){
   $datas=array('DESCRIPTION'=>$DESCRIPTION,'MONTANT_ACHAT'=>$this->input->post('PRIX'));
  $this->Model->update('serv_type_service',array('ID_TYPE_SERVICE'=>$ID_TYPE_SERVICE),$datas);
    $message = "<div class='alert alert-success' id='message'>
                            Type de Service mis a jour avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";


   
    $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('service/Type_Service/listing'));                  
                    }else{

      $data['title']=' Type Service';
      $data['stitle']=' Type Service';
      $data['selected']=$this->Model->getOne('serv_type_service',array('ID_TYPE_SERVICE'=>$id));
       $message = "<div class='alert alert-danger' id='message'>
         Type de Service mis exité déjà!  <button type='button' class='close' data-dismiss='alert'>&times;</button> </div>";

  $this->session->set_flashdata(array('message'=>$message));
      $this->load->view('Type_Service_Update_View',$data);

                    }
  
    

   }
    }


  public function desactiver($id)
    {
      $this->Model->update('serv_type_service',array('ID_TYPE_SERVICE'=>$id),array('STATUS'=>0));
      $message = "<div class='alert alert-success' id='message'>
                            Type de Service désactivé avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
      $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('service/Type_Service/listing')); 
    }

  public function reactiver($id)
    {
      $this->Model->update('serv_type_service',array('ID_TYPE_SERVICE'=>$id),array('STATUS'=>1));
      $message = "<div class='alert alert-success' id='message'>
                            Type de Service Réactivé avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
      $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('service/Type_Service/listing')); 
    }

    public function details()
    {
      $data['title']=' Type de Service';
      $data['stitle']=' Type de Service';
      $this->load->view('Type_Service_Details_View',$data);
    }




}
?>