<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Structure_Sanitaire extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->Is_Connected();
    }

    public function Is_Connected()
       {

       if (empty($this->session->userdata('MIS_ID_USER')))
        {
         redirect(base_url('Login/'));
        }
       }

    public function index()
    {
      $data['title']=' Stucture Sanitaire';
      $data['stitle']=' Stucture Sanitaire';
      $data['province'] = $this->Model->getListOrdertwo('syst_provinces',array(),'PROVINCE_NAME'); 
      $data['commune'] = $this->Model->getList('syst_communes');
      $data['type_str'] = $this->Model->getList('syst_couverture_structure'); 
      $this->load->view('Structure_Sanitaire_Add_View',$data);
    }


 public function get_commune()
  {
  $commune= $this->Model->getList("syst_communes",array('PROVINCE_ID'=>$this->input->post('provine_id')));
  $datas= '<option value="">-- Sélectionner --</option>';
  foreach($commune as $commun){
  $datas.= '<option value="'.$commun["COMMUNE_ID"].'">'.$commun["COMMUNE_NAME"].'</option>';
  }
  $datas.= '';
  echo $datas;
  }


    public function add()
  {

  $DESCRIPTION=$this->input->post('DESCRIPTION');
  $ID_TYPE_STRUCTURE=$this->input->post('ID_TYPE_STRUCTURE');
  $PROVINCE_ID=$this->input->post('PROVINCE_ID');
  $COMMUNE_ID=$this->input->post('COMMUNE_ID');

   $this->form_validation->set_rules('DESCRIPTION', 'Nom', 'required');
   $this->form_validation->set_rules('ID_TYPE_STRUCTURE', 'Type de structure', 'required');
   $this->form_validation->set_rules('PROVINCE_ID', 'Province', 'required');
   $this->form_validation->set_rules('COMMUNE_ID', 'Commune', 'required');

   if ($this->form_validation->run() == FALSE){
    $message = "<div class='alert alert-danger' id='message'>
                            Stucture sanitaire non enregistr&eacute;
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
    $data['title']=' Stucture Sanitaire';
    $data['stitle']=' Stucture Sanitaire';
    $data['province'] = $this->Model->getListOrdertwo('syst_provinces'); 
    $data['commune'] = $this->Model->getList('syst_communes');
    $data['type_str'] = $this->Model->getList('syst_couverture_structure'); 
    $this->load->view('Structure_Sanitaire_Add_View',$data);
   }
   else{

    $datas=array('DESCRIPTION'=>$DESCRIPTION,
                 'ID_TYPE_STRUCTURE'=>$ID_TYPE_STRUCTURE,
                 'PROVINCE_ID'=>$PROVINCE_ID,
                 'COMMUNE_ID'=>$COMMUNE_ID,
                );


    $this->Model->insert_last_id('masque_stucture_sanitaire',$datas);
  
    $message = "<div class='alert alert-success' id='message'>
                            Stucture Sanitaire enregistr&eacute; avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('saisie/Structure_Sanitaire/listing'));    

   }
   

  }

     public function listing()
    {

      $resultat=$this->Model->getRequete('SELECT masque_stucture_sanitaire.ID_STRUCTURE, masque_stucture_sanitaire.DESCRIPTION AS NOMSTRUCTURE, syst_couverture_structure.DESCRIPTION AS TYPESTRUCT, syst_provinces.PROVINCE_NAME, syst_communes.COMMUNE_NAME, masque_stucture_sanitaire.STATUS FROM `masque_stucture_sanitaire` JOIN syst_provinces ON syst_provinces.PROVINCE_ID = masque_stucture_sanitaire.PROVINCE_ID JOIN syst_communes ON syst_communes.COMMUNE_ID = masque_stucture_sanitaire.COMMUNE_ID JOIN syst_couverture_structure ON syst_couverture_structure.ID_TYPE_STRUCTURE = masque_stucture_sanitaire.ID_TYPE_STRUCTURE');
      //WHERE reservation_chambre.STATUT_RESERV_ID=1
      $tabledata=array();
      
      foreach ($resultat as $key) 
         {
          if ($key['STATUS'] == 1) {
            $stat = 'Actif';
            $fx = 'desactiver';
            $col = 'btn-danger';
            $titr = 'Désactiver';
            $stitr = 'voulez-vous désactiver structure sanitaire ';
            $bigtitr = 'Désactivation du Stucture sanitaire';
          }
          else{
            $stat = 'Innactif';
            $fx = 'reactiver';
            $col = 'btn-success';
            $titr = 'Réactiver';
            $stitr = 'voulez-vous réactiver structure sanitaire ';
            $bigtitr = 'Réactivation du Stucture sanitaire';
          }
          $chambr=array();
          $chambr[]=$key['NOMSTRUCTURE'];
          $chambr[]=$key['TYPESTRUCT'];  
          $chambr[]=$key['PROVINCE_NAME'];  
          $chambr[]=$key['COMMUNE_NAME'];  
          $chambr[]=$stat;
          $chambr[]='<div class="modal fade" id="desactcat'.$key['ID_STRUCTURE'].'" tabindex="-1" role="dialog" aria-labelledby="basicModal" aria-hidden="true">
  <div class="modal-dialog modal-sm">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel">'.$bigtitr.'</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <h6><b>Mr/Mme , </b> '.$stitr.' ('.$key['NOMSTRUCTURE'].')?</h6>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
        <a href="'.base_url('saisie/Structure_Sanitaire/'.$fx.'/'.$key['ID_STRUCTURE']).'" class="btn '.$col.'">'.$titr.'</a>
      </div>
    </div>
  </div>
</div>

          <div class="dropdown ">
                    <a class="btn btn-primary btn-sm dropdown-toggle" data-toggle="dropdown">Actions
                    <span class="caret"></span></a>
                    <ul class="dropdown-menu dropdown-menu-right">
                    <li><a class="dropdown-item" href="'.base_url('saisie/Structure_Sanitaire/index_update/'.$key['ID_STRUCTURE']).'"> Modifier </a> </li>
                    <li><a class="dropdown-item" href="#" data-toggle="modal" data-target="#desactcat'.$key['ID_STRUCTURE'].'"> '.$titr.' </a> </li>
                    </ul>
                  </div>';
         
                          
       $tabledata[]=$chambr;
     
     }

        $template = array(
            'table_open' => '<table id="mytable" class="table table-bordered table-striped">',
            'table_close' => '</table>'
        );
        $this->table->set_template($template);
        $this->table->set_heading(array('Nom','Type','Province','Commune','Status','Option'));
        $data['title'] = " Structure Sanitaire";
        $data['chamb']=$tabledata;
        $data['stitle']=' Structure Sanitaire';
        $this->load->view('Structure_Sanitaire_List_View',$data);

    }

    public function index_update($id)
    {

      $data['title']=' Stucture Sanitaire';
      $data['stitle']=' Stucture Sanitaire';
      $selected = $this->Model->getOne('masque_stucture_sanitaire',array('ID_STRUCTURE'=>$id)); 
      $data['province'] = $this->Model->getListOrdertwo('syst_provinces',array(),'PROVINCE_NAME'); 
      $data['commune'] = $this->Model->getListOrdertwo('syst_communes',array('PROVINCE_ID'=>$selected['PROVINCE_ID']),'COMMUNE_NAME');
      $data['type_str'] = $this->Model->getList('syst_couverture_structure'); 
      $data['selected'] = $this->Model->getOne('masque_stucture_sanitaire',array('ID_STRUCTURE'=>$id)); 
      $this->load->view('Structure_Sanitaire_Update_View',$data);
    }


     public function update()
  {

  $DESCRIPTION=$this->input->post('DESCRIPTION');
  $ID_TYPE_STRUCTURE=$this->input->post('ID_TYPE_STRUCTURE');
  $PROVINCE_ID=$this->input->post('PROVINCE_ID');
  $COMMUNE_ID=$this->input->post('COMMUNE_ID');
  $ID_STRUCTURE=$this->input->post('ID_STRUCTURE');

   $this->form_validation->set_rules('DESCRIPTION', 'Nom', 'required');
   $this->form_validation->set_rules('ID_TYPE_STRUCTURE', 'Type de structure', 'required');
   $this->form_validation->set_rules('PROVINCE_ID', 'Province', 'required');
   $this->form_validation->set_rules('COMMUNE_ID', 'Commune', 'required');

   if ($this->form_validation->run() == FALSE){
    $message = "<div class='alert alert-danger' id='message'>
                            Stucture sanitaire non enregistr&eacute;
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
      $data['title']=' Stucture Sanitaire';
      $data['stitle']=' Stucture Sanitaire';
      $selected = $this->Model->getOne('masque_stucture_sanitaire',array('ID_STRUCTURE'=>$ID_STRUCTURE)); 
      $data['province'] = $this->Model->getListOrdertwo('syst_provinces',array(),'PROVINCE_NAME'); 
      $data['commune'] = $this->Model->getListOrdertwo('syst_communes',array('PROVINCE_ID'=>$selected['PROVINCE_ID']),'COMMUNE_NAME');
      $data['type_str'] =$this->Model->getList('syst_couverture_structure'); 
      $data['selected'] = $this->Model->getOne('masque_stucture_sanitaire',array('ID_STRUCTURE'=>$ID_STRUCTURE)); 
      $this->load->view('Structure_Sanitaire_Update_View',$data);
   }
   else{

    $datas=array('DESCRIPTION'=>$DESCRIPTION,
                 'ID_TYPE_STRUCTURE'=>$ID_TYPE_STRUCTURE,
                 'PROVINCE_ID'=>$PROVINCE_ID,
                 'COMMUNE_ID'=>$COMMUNE_ID,
                );

    $this->Model->update('masque_stucture_sanitaire',array('ID_STRUCTURE'=>$ID_STRUCTURE),$datas);
  
    $message = "<div class='alert alert-success' id='message'>
                            Stucture Sanitaire modifi&eacute; avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('saisie/Structure_Sanitaire/listing'));    

   }

  }


  public function desactiver($id)
    {
      $this->Model->update('masque_stucture_sanitaire',array('ID_STRUCTURE'=>$id),array('STATUS'=>0));
      $message = "<div class='alert alert-success' id='message'>
                            Stucture sanitaire désactivé avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
      $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('saisie/Structure_Sanitaire/listing')); 
    }

  public function reactiver($id)
    {
      $this->Model->update('masque_stucture_sanitaire',array('ID_STRUCTURE'=>$id),array('STATUS'=>1));
      $message = "<div class='alert alert-success' id='message'>
                            Stucture sanitaire Réactivé avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
      $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('saisie/Structure_Sanitaire/listing')); 
    }

    public function details()
    {
      $data['title']=' Client';
      $data['stitle']=' Client';
      $this->load->view('Client_Details_View',$data);
    }



}
?>