<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Groupe extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->Is_Connected();
    }

    public function Is_Connected()
       {

       if (empty($this->session->userdata('MIS_ID_USER')))
        {
         redirect(base_url('Login/'));
        }
       }

    public function index()
    {
      $data['title']=' Groupe d\'affilié ';
      $data['stitle']=' Groupe d\'affilié ';
      // $data['type_med'] = $this->Model->getList('syst_couverture_medicament'); 
      $this->load->view('Groupe_Add_View',$data);
    }


    public function add()
    {

  $NOM_GROUPE=$this->input->post('NOM_GROUPE');
  $DATE_ENREGISTREMENT=$this->input->post('DATE_ENREGISTREMENT');

   $this->form_validation->set_rules('NOM_GROUPE', 'Nom', 'required');
   $this->form_validation->set_rules('DATE_ENREGISTREMENT', 'Date de debut', 'required');
   if ($this->form_validation->run() == FALSE){
    $message = "<div class='alert alert-danger' id='message'>
                            Groupe non enregistr&eacute;
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
    $data['title']=' Groupe d\'affilié ';
    $data['stitle']=' Groupe d\'affilié ';
    $this->load->view('Groupe_Add_View',$data);
   }
   else{

    $datas=array('NOM_GROUPE'=>$NOM_GROUPE,
                 'DATE_ENREGISTREMENT'=>$DATE_ENREGISTREMENT,
                );


    $this->Model->insert_last_id('membre_groupe',$datas);
  
    $message = "<div class='alert alert-success' id='message'>
                            Groupe enregistr&eacute; avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('membre/Groupe/listing'));    

   }
   

  }

     public function listing()
    {

      $resultat=$this->Model->getRequete('SELECT DISTINCT(membre_groupe.ID_GROUPE) AS ID_GROUPE, membre_groupe.NOM_GROUPE, membre_groupe.DATE_ENREGISTREMENT, membre_groupe.STATUS, COUNT(membre_groupe_membre.ID_MEMBRE) AS MEMBRE FROM `membre_groupe` LEFT JOIN membre_groupe_membre ON membre_groupe.ID_GROUPE = membre_groupe_membre.ID_GROUPE GROUP BY membre_groupe.ID_GROUPE, membre_groupe.NOM_GROUPE, membre_groupe.DATE_ENREGISTREMENT, membre_groupe.STATUS');
      //WHERE reservation_chambre.STATUT_RESERV_ID=1
      $tabledata=array();
      
      foreach ($resultat as $key) 
         {
          if ($key['STATUS'] == 1) {
            $stat = 'Actif';
            $fx = 'desactiver';
            $col = 'btn-danger';
            $titr = 'Désactiver';
            $stitr = 'voulez-vous désactiver le groupe ';
            $bigtitr = 'Désactivation du groupe';
          }
          else{
            $stat = 'Innactif';
            $fx = 'reactiver';
            $col = 'btn-success';
            $titr = 'Réactiver';
            $stitr = 'voulez-vous réactiver le groupe ';
            $bigtitr = 'Réactivation du groupe';
          }
          $chambr=array();
          $chambr[]=$key['NOM_GROUPE'];
          $chambr[]=$key['DATE_ENREGISTREMENT'];   
          $chambr[]=$key['MEMBRE'];
          $chambr[]=$stat;
          $chambr[]='<div class="modal fade" id="desactcat'.$key['ID_GROUPE'].'" tabindex="-1" role="dialog" aria-labelledby="basicModal" aria-hidden="true">
  <div class="modal-dialog modal-sm">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel">'.$bigtitr.'</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <h6><b>Mr/Mme , </b> '.$stitr.' ('.$key['NOM_GROUPE'].')?</h6>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Annuler</button>
        <a href="'.base_url('membre/Groupe/'.$fx.'/'.$key['ID_GROUPE']).'" class="btn '.$col.'">'.$titr.'</a>
      </div>
    </div>
  </div>
</div>

          <div class="dropdown ">
                    <a class="btn btn-primary btn-sm dropdown-toggle" data-toggle="dropdown">Actions
                    <span class="caret"></span></a>
                    <ul class="dropdown-menu dropdown-menu-right">
                    <li><a class="dropdown-item" href="'.base_url('membre/Groupe/index_update/'.$key['ID_GROUPE']).'"> Modifier </a> </li>
                    <li><a class="dropdown-item" href="'.base_url('membre/Groupe/details/'.$key['ID_GROUPE']).'"> Details </a> </li>
                    <li><a class="dropdown-item" href="#" data-toggle="modal" data-target="#desactcat'.$key['ID_GROUPE'].'"> '.$titr.' </a> </li>
                    </ul>
                  </div>';
         
                          
       $tabledata[]=$chambr;
     
     }

        $template = array(
            'table_open' => '<table id="mytable" class="table table-bordered table-striped">',
            'table_close' => '</table>'
        );
        $this->table->set_template($template);
        $this->table->set_heading(array('Nom','Date Debut','Nb Membre','Status','Option'));
        $data['title'] = " Groupe d'affilié";
        $data['chamb']=$tabledata;
        $data['stitle']=' Groupe d\'affilié';
        $this->load->view('Groupe_List_View',$data);

    }

    public function details($id)
    {

      $data['title']=' Groupe';
      $data['stitle']=' Groupe';
      // $data['type_med'] = $this->Model->getList('syst_couverture_medicament'); 
      $data['selected'] = $this->Model->getRequeteOne('SELECT DISTINCT(membre_groupe.ID_GROUPE) AS ID_GROUPE, membre_groupe.NOM_GROUPE, membre_groupe.DATE_ENREGISTREMENT, membre_groupe.STATUS, COUNT(membre_groupe_membre.ID_MEMBRE) AS MEMBRE FROM `membre_groupe` LEFT JOIN membre_groupe_membre ON membre_groupe.ID_GROUPE = membre_groupe_membre.ID_GROUPE WHERE membre_groupe.ID_GROUPE = '.$id.' GROUP BY membre_groupe.ID_GROUPE, membre_groupe.NOM_GROUPE, membre_groupe.DATE_ENREGISTREMENT, membre_groupe.STATUS  '); 
      $data['list'] = $this->Model->getRequete('SELECT membre_membre.ID_MEMBRE, CODE_AFILIATION, NOM, PRENOM, CNI, DATE_ADHESION, membre_membre.STATUS, IS_AFFILIE FROM membre_membre JOIN membre_groupe_membre ON membre_groupe_membre.ID_MEMBRE = membre_membre.ID_MEMBRE WHERE 1 AND membre_groupe_membre.ID_GROUPE = '.$id.' '); 
      $this->load->view('Groupe_Details_View',$data);
    }

    public function index_update($id)
    {

      $data['title']=' Groupe';
      $data['stitle']=' Groupe';
      // $data['type_med'] = $this->Model->getList('syst_couverture_medicament'); 
      $data['selected'] = $this->Model->getOne('membre_groupe',array('ID_GROUPE'=>$id)); 
      $this->load->view('Groupe_Update_View',$data);
    }



     public function update()
  {

  $NOM_GROUPE=$this->input->post('NOM_GROUPE');
  $DATE_ENREGISTREMENT=$this->input->post('DATE_ENREGISTREMENT');
  $ID_GROUPE=$this->input->post('ID_GROUPE');

   $this->form_validation->set_rules('NOM_GROUPE', 'Nom du groupe', 'required');
   $this->form_validation->set_rules('DATE_ENREGISTREMENT', 'Date enregistrement', 'required');
   if ($this->form_validation->run() == FALSE){
    $message = "<div class='alert alert-danger' id='message'>
                            Groupe d'affilié non modifi&eacute;
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
    $data['title']=' Groupe d\'affilié ';
    $data['stitle']=' Groupe d\'affilié ';
    // $data['type_med'] = $this->Model->getList('syst_couverture_medicament'); 
    $data['selected'] = $this->Model->getOne('membre_groupe',array('ID_GROUPE'=>$ID_GROUPE)); 
    $this->load->view('Groupe_Update_View',$data);
   }
   else{

    $datas=array('NOM_GROUPE'=>$NOM_GROUPE,
                 'DATE_ENREGISTREMENT'=>$DATE_ENREGISTREMENT,
                );


    $this->Model->update('membre_groupe',array('ID_GROUPE'=>$ID_GROUPE),$datas);
  
    $message = "<div class='alert alert-success' id='message'>
                            Groupe modifi&eacute; avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
    $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('membre/Groupe/listing'));    

   }

  }


  public function desactiver($id)
    {
      $this->Model->update('membre_groupe',array('ID_GROUPE'=>$id),array('STATUS'=>0));
      $message = "<div class='alert alert-success' id='message'>
                            Groupe désactivé avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
      $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('membre/Groupe/listing')); 
    }

  public function reactiver($id)
    {
      $this->Model->update('membre_groupe',array('ID_GROUPE'=>$id),array('STATUS'=>1));
      $message = "<div class='alert alert-success' id='message'>
                            Groupe Réactivé avec succés
                            <button type='button' class='close' data-dismiss='alert'>&times;</button>
                      </div>";
      $this->session->set_flashdata(array('message'=>$message));
      redirect(base_url('membre/Groupe/listing')); 
    }

    
}
?>